/* 
 *  StringDataTabBase.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DataI;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;

public class StringDataTabBase {

    protected final Tab tab;
    protected final TextArea dataEditor;
    protected final String BLANKDATA = "no DATA to display";
    protected final BorderPane pane;

    public StringDataTabBase() {
        dataEditor = new TextArea();
        dataEditor.getStyleClass().add("dataEditor");
        dataEditor.setText(BLANKDATA);
        dataEditor.setEditable(false);
        tab = new Tab();
        tab.setText("String");
        tab.setClosable(false);

        tab.setContent(dataEditor);
        tab.setDisable(true);

        pane = new BorderPane();
        pane.setCenter(dataEditor);
        tab.setContent(pane);
    }

    public Tab getTab() {
        return tab;
    }

    void update(InteractionDataI data) {
//        boolean disable = !data.canGetData();
    	boolean disable = false;
        this.dataEditor.setDisable(disable);
        this.tab.setDisable(disable);

        DataI dataInstance = data.getData();
        if (dataInstance != null) {
            switch (dataInstance.getFormat()) {
                case BIN:
                    this.tab.setDisable(true);
                    break;
                case KVP:
                    this.tab.setDisable(true);
                    break;
                case STR:
                    dataEditor.setText(dataInstance.getStringData());
                    break;
                case UNKNOWN:
                    dataEditor.setText(BLANKDATA);
                    break;
            }
        } else {
            dataEditor.setText(BLANKDATA);
        }
    }
}
